<?php

// +----------------------------------------------------------------------+
// | Post Sale module for IPB                                             |
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 HyPER Studio                                      |
// +----------------------------------------------------------------------+
// | Post Sale module for Invision Board v1.2 Chinese HyPER Version       |
// |                                                                      |
// | Technical Support : http://www.freeipb.com/                          |
// +----------------------------------------------------------------------+
// | Author: tntxhy <tntxhy@msn.com>                                      |
// +----------------------------------------------------------------------+


$idx = new Sale;

class Sale {

    var $output     = "";
    var $page_title = "";
    var $nav        = array();
    var $html       = "";
    var $base_url   = "";
    var $rd_url		= "";
    function Sale() {
    	global $ibforums, $DB, $std, $print;

		//-------------------------------------
        // Check the input
        //-------------------------------------
        
        $ibforums->input['p'] = $std->is_number($ibforums->input['p']);

		if ( $ibforums->input['p']<0 )
		{
			$std->Error( array( LEVEL => 1, MSG => 'missing_files') );
		}

    	//--------------------------------------------
    	// Require the HTML and language modules
    	//--------------------------------------------
    	
		$ibforums->lang = $std->load_words($ibforums->lang, 'lang_topic', $ibforums->lang_id );
		
    	$this->html = $std->load_template('skin_topic'); 
    	
    	$this->base_url = $ibforums->base_url;
    	

		switch($ibforums->input['CODE']) {
			case '00':
    			$this->buy_post();
    			break;
    		case '01':
    			$this->show_customer("p");
    			break;
    		case '02':
    			$this->show_customer("a");
    			break;    			
			default:
    			$this->buy_post();
    			break;
    	}
	}

	function buy_post() {
		global $DB,$ibforums,$print,$std;
		$DB->query("SELECT s.customer,p.author_id,p.topic_id,p.forum_id,p.post_price FROM ibf_sale s,ibf_posts p WHERE s.mode='p' AND s.pid='".$ibforums->input['p']."' AND s.pid=p.pid");
		if(!$DB->get_num_rows())
		{
			$std->Error( array( LEVEL => 1, MSG => 'missing_files') );
		}
		else
		{
			$row = $DB->fetch_row();
			if(preg_match("#\|".$ibforums->member['uid']."\|#",$row['customer']))
			{
				$std->Error( array( LEVEL => 1, MSG => 'sale_already_buy') );
				exit;
			}
			if($ibforums->member['money']<$row['post_price'])
			{
				$std->Error( array( LEVEL => 1, MSG => 'sale_not_enough_money') );
				exit;
			}
			else
			{
				$DB->query("UPDATE ibf_members SET money=money-".$row['post_price']." WHERE uid='".$ibforums->member['uid']."'");
				$DB->query("UPDATE ibf_members SET money=money+".$row['post_price']." WHERE uid='".$row['author_id']."'");
				
				$sale['customer'] = $row['customer'].$ibforums->member['uid']."|";
				
				$DB->query("UPDATE ibf_sale SET customer='".$sale['customer']."' WHERE mode='p' AND pid='".$ibforums->input['p']."'");
				$print->redirect_screen($ibforums->lang['buy_successful'],"act=ST&f=".$row['forum_id']."&t=".$row['topic_id']."&#entry".$ibforums->input['p']);
				exit();
			}
		}
	}	
	
	function show_customer( $mode ) {
		global $DB,$ibforums,$print,$std;
		$DB->query("SELECT customer FROM ibf_sale WHERE mode='".$mode."' AND pid=".$ibforums->input['p']);
		if(!$DB->get_num_rows())
		{
			$std->Error( array( LEVEL => 1, MSG => 'missing_files') );
		}
		else
		{
			$customer_data = $DB->fetch_row();
		}		
		$customer = preg_replace("#\|(.*)\|#","\\1",$customer_data['customer']);
		$customer = str_replace("|",",",$customer);
		$DB->query("SELECT uid,uname FROM ibf_members WHERE uid IN(".$customer.")");
		$html = $this->html->show_customer_head();
		while ($row=$DB->fetch_row()) {
			$html .= $this->html->show_customer_row($row);
		}
		$html .= $this->html->show_customer_foot();		
		$print->pop_up_window( $ibforums->lang['cur_customer'], $html );
	}
	
}
?>
